/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;

class ErestorOfTheCouncilEffect
extends OneShotEffect {
    ErestorOfTheCouncilEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent who voted for a choice you voted for creates a Treasure token. You scry X, where X is the number of opponents who voted for a choice you didn't vote for";
    }

    private ErestorOfTheCouncilEffect(ErestorOfTheCouncilEffect effect) {
        super((OneShotEffect)effect);
    }

    public ErestorOfTheCouncilEffect copy() {
        return new ErestorOfTheCouncilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set playerIds = (Set)this.getValue("votedAgainst");
        int scryCount = 0;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            if (playerIds.contains(opponentId)) {
                ++scryCount;
                continue;
            }
            new TreasureToken().putOntoBattlefield(1, game, source, opponentId);
        }
        if (scryCount > 0) {
            new ScryEffect(scryCount).apply(game, source);
        }
        return true;
    }
}

