/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.effects.common.combat.CantAttackYouAllEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.EnchantedBySourceControllerPredicate;

public final class ErietteOfTheCharmedApple
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("each creature that's enchanted by an Aura you control");
    private static final DynamicValue count = new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledPermanent(SubType.AURA));

    public ErietteOfTheCharmedApple(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{W}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.WARLOCK);
        this.power = new MageInt(2);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CantAttackYouAllEffect(Duration.WhileOnBattlefield, filter, true)));
        BeginningOfEndStepTriggeredAbility ability = new BeginningOfEndStepTriggeredAbility((Effect)new LoseLifeOpponentsEffect(count).setText("each opponent loses X life"));
        ability.addEffect((Effect)new GainLifeEffect(count).setText("and you gain X life, where X is the number of Auras you control"));
        ability.addHint((Hint)new ValueHint("Number of Auras you control", count));
        this.addAbility((Ability)ability);
    }

    private ErietteOfTheCharmedApple(ErietteOfTheCharmedApple card) {
        super((CardImpl)card);
    }

    public ErietteOfTheCharmedApple copy() {
        return new ErietteOfTheCharmedApple(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)EnchantedBySourceControllerPredicate.instance);
    }
}

