/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.ErietteTheBeguilerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ErietteTheBeguilerTriggeredAbility
extends TriggeredAbilityImpl {
    ErietteTheBeguilerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ErietteTheBeguilerEffect());
    }

    private ErietteTheBeguilerTriggeredAbility(ErietteTheBeguilerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ErietteTheBeguilerTriggeredAbility copy() {
        return new ErietteTheBeguilerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACHED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent aura = game.getPermanent(event.getSourceId());
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (aura == null || permanent == null || !aura.isControlledBy(this.getControllerId()) || !aura.hasSubtype(SubType.AURA, game) || permanent.isLand(game) || !game.getOpponents(this.getControllerId()).contains(permanent.getControllerId()) || aura.getManaValue() < permanent.getManaValue()) {
            return false;
        }
        this.getEffects().setValue("auraRef", (Object)new MageObjectReference((MageObject)aura, game));
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public String getRule() {
        return "Whenever an Aura you control becomes attached to a nonland permanent an opponent controls with mana value less than or equal to that Aura's mana value, gain control of that permanent for as long as that Aura is attached to it.";
    }
}

