/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ErraticExplosionEffect
extends OneShotEffect {
    ErraticExplosionEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose any target. Reveal cards from the top of your library until you reveal a nonland card. {this} deals damage equal to that card's mana value to that permanent or player. Put the revealed cards on the bottom of your library in any order";
    }

    private ErraticExplosionEffect(ErraticExplosionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ErraticExplosionEffect copy() {
        return new ErraticExplosionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl toReveal = new CardsImpl();
            Card nonLandCard = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                if (card.isLand(game)) continue;
                nonLandCard = card;
                break;
            }
            controller.revealCards(source, (Cards)toReveal, game);
            if (nonLandCard != null) {
                Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetCreature != null) {
                    targetCreature.damage(nonLandCard.getManaValue(), source.getSourceId(), source, game, false, true);
                } else {
                    Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                    if (targetPlayer != null) {
                        targetPlayer.damage(nonLandCard.getManaValue(), source.getSourceId(), source, game);
                    }
                }
            }
            return controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, true);
        }
        return false;
    }
}

