/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.FilterStackObject;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.TargetsPermanentOrPlayerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ErthaJoFrontierMentorTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterStackObject filter = new FilterStackObject("ability that targets a creature or player");

    public ErthaJoFrontierMentorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyStackObjectEffect(), false);
        this.setTriggerPhrase("Whenever you activate an ability that targets a creature or player, ");
    }

    private ErthaJoFrontierMentorTriggeredAbility(ErthaJoFrontierMentorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ErthaJoFrontierMentorTriggeredAbility copy() {
        return new ErthaJoFrontierMentorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null || !event.getPlayerId().equals(this.getControllerId()) || !filter.match(stackObject, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new TargetsPermanentOrPlayerPredicate((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, new FilterPlayer()));
    }
}

