/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class EshkiDragonclawWatcher
extends Watcher {
    private final Map<UUID, Integer> creatureCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> nonCreatureCount = new HashMap<UUID, Integer>();

    EshkiDragonclawWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null) {
            return;
        }
        if (spell.isCreature(game)) {
            this.creatureCount.compute(spell.getControllerId(), CardUtil::setOrIncrementValue);
        } else {
            this.nonCreatureCount.compute(spell.getControllerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.creatureCount.clear();
        this.nonCreatureCount.clear();
    }

    private int checkCreature(UUID playerId) {
        return this.creatureCount.getOrDefault(playerId, 0) > 0 ? 1 : 0;
    }

    private int checkNonCreature(UUID playerId) {
        return this.nonCreatureCount.getOrDefault(playerId, 0) > 0 ? 2 : 0;
    }

    private int check(UUID playerId) {
        return this.checkCreature(playerId) + this.checkNonCreature(playerId);
    }

    static int checkPlayer(UUID playerId, Game game) {
        return ((EshkiDragonclawWatcher)game.getState().getWatcher(EshkiDragonclawWatcher.class)).check(playerId);
    }
}

