/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.CopyTokenFunction;
import mage.util.functions.EmptyCopyApplier;
import mage.watchers.common.CreatedTokenWatcher;

class EsixFractalBloomEffect
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("another creature");

    EsixFractalBloomEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, false);
        this.staticText = "the first time you would create one or more tokens during each of your turns, you may instead choose a creature other than {this} and create that many tokens that are copies of that creature";
    }

    private EsixFractalBloomEffect(EsixFractalBloomEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId()) && game.isActivePlayer(source.getControllerId()) && !CreatedTokenWatcher.checkPlayer((UUID)source.getControllerId(), (Game)game) && game.getBattlefield().count(filter, source.getControllerId(), source, game) > 0;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (event instanceof CreateTokenEvent) {
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            int amount = tokenEvent.getAmount();
            tokenEvent.getTokens().clear();
            tokenEvent.getTokens().put(EsixFractalBloomEffect.copyPermanentToToken(permanent, game, source), amount);
        }
        return false;
    }

    public EsixFractalBloomEffect copy() {
        return new EsixFractalBloomEffect(this);
    }

    private static Token copyPermanentToToken(Permanent permanent, Game game, Ability source) {
        EmptyCopyApplier applier = new EmptyCopyApplier();
        Permanent copyFromPermanent = permanent;
        for (ContinuousEffect effect : game.getState().getContinuousEffects().getLayeredEffects(game)) {
            MageObject object;
            CopyEffect copyEffect;
            if (!(effect instanceof CopyEffect) || !(copyEffect = (CopyEffect)effect).getSourceId().equals(permanent.getId()) || !((object = ((CopyEffect)effect).getTarget()) instanceof Permanent)) continue;
            copyFromPermanent = (Permanent)object;
            if (copyEffect.getApplier() == null) continue;
            applier = copyEffect.getApplier();
        }
        Token token = CopyTokenFunction.createTokenCopy((Card)copyFromPermanent, (Game)game);
        applier.apply(game, (MageObject)token, source, permanent.getId());
        return token;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

