/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.condition.common.CastFromGraveyardSourceCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class EsperOriginsEffect
extends OneShotEffect {
    EsperOriginsEffect() {
        super(Outcome.Benefit);
        this.staticText = "If this spell was cast from a graveyard, exile it, then put it onto the battlefield transformed under its owner's control with a finality counter on it.";
    }

    private EsperOriginsEffect(EsperOriginsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EsperOriginsEffect copy() {
        return new EsperOriginsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!CastFromGraveyardSourceCondition.instance.apply(game, source)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = game.getSpell(source.getId());
        if (player == null || spell == null) {
            return false;
        }
        Card card = spell.getMainCard();
        player.moveCards(card, Zone.EXILED, source, game);
        game.setEnterWithCounters(card.getId(), new Counters(new Counter[]{CounterType.FINALITY.createInstance()}));
        game.getState().setValue("EnterTransformed" + card.getId(), (Object)Boolean.TRUE);
        player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

