/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class EssenceBacklashEffect
extends OneShotEffect {
    EssenceBacklashEffect() {
        super(Outcome.Damage);
        this.staticText = "Counter target creature spell. {this} deals damage equal to that spell's power to its controller";
    }

    private EssenceBacklashEffect(EssenceBacklashEffect effect) {
        super((OneShotEffect)effect);
    }

    public EssenceBacklashEffect copy() {
        return new EssenceBacklashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        if (spell != null) {
            Player spellController = game.getPlayer(spell.getControllerId());
            result = game.getStack().counter(source.getFirstTarget(), source, game);
            if (spellController != null) {
                spellController.damage(spell.getPower().getValue(), source.getSourceId(), source, game);
            }
        }
        return result;
    }
}

