/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.ProtectedByOpponentPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EtchedHostDoombringerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    EtchedHostDoombringerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target battle. If an opponent protects it, remove three defense counters from it. Otherwise, put three defense counters on it";
    }

    private EtchedHostDoombringerEffect(EtchedHostDoombringerEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtchedHostDoombringerEffect copy() {
        return new EtchedHostDoombringerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (!filter.match(permanent, source.getControllerId(), source, game)) {
            return permanent.addCounters(CounterType.DEFENSE.createInstance(3), source, game);
        }
        permanent.removeCounters(CounterType.DEFENSE.createInstance(3), source, game);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ProtectedByOpponentPredicate.instance);
    }
}

