/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.common.DamagedByControlledWatcher;

class EtchingOfKumanoReplacementEffect
extends ReplacementEffectImpl {
    EtchingOfKumanoReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a creature dealt damage this turn by a source you controlled would die, exile it instead";
    }

    private EtchingOfKumanoReplacementEffect(EtchingOfKumanoReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public EtchingOfKumanoReplacementEffect copy() {
        return new EtchingOfKumanoReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamagedByControlledWatcher watcher;
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        if (zce.isDiesEvent() && (watcher = (DamagedByControlledWatcher)game.getState().getWatcher(DamagedByControlledWatcher.class, source.getControllerId())) != null) {
            return watcher.wasDamaged(zce.getTarget(), game);
        }
        return false;
    }
}

