/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EternityVesselEffect
extends OneShotEffect {
    EternityVesselEffect() {
        super(Outcome.Benefit);
        this.staticText = "with X charge counters on it, where X is your life total";
    }

    private EternityVesselEffect(EternityVesselEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent vessel = game.getPermanentEntering(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (vessel != null && controller != null) {
            int amount = controller.getLife();
            if (amount > 0) {
                vessel.addCounters(CounterType.CHARGE.createInstance(amount), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public EternityVesselEffect copy() {
        return new EternityVesselEffect(this);
    }
}

