/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.e.EvelynTheCovetousWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.util.CardUtil;

class EvelynTheCovetousCastEffect
extends AsThoughEffectImpl {
    EvelynTheCovetousCastEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.PlayForFree);
        this.staticText = "once each turn, you may play a card from exile with a collection counter on it if it was exiled by an ability you controlled";
    }

    private EvelynTheCovetousCastEffect(EvelynTheCovetousCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public EvelynTheCovetousCastEffect copy() {
        return new EvelynTheCovetousCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || EvelynTheCovetousWatcher.checkUsed(source, game)) {
            return false;
        }
        Card card = game.getCard(CardUtil.getMainCardId((Game)game, (UUID)sourceId));
        return card != null && card.getCounters(game).getCount(CounterType.COLLECTION) > 0 && EvelynTheCovetousWatcher.checkExile(affectedControllerId, card, game, 0);
    }
}

