/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class EvolutionaryEscalationEffect
extends OneShotEffect {
    EvolutionaryEscalationEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put three +1/+1 counters on target creature you control and three +1/+1 counters on target creature an opponent controls";
    }

    private EvolutionaryEscalationEffect(EvolutionaryEscalationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Counter counter = CounterType.P1P1.createInstance(3);
        boolean addedCounters = false;
        for (Target target : source.getTargets()) {
            Permanent targetPermanent = game.getPermanent(target.getFirstTarget());
            if (targetPermanent == null) continue;
            targetPermanent.addCounters(counter.copy(), source.getControllerId(), source, game);
            addedCounters = true;
        }
        return addedCounters;
    }

    public EvolutionaryEscalationEffect copy() {
        return new EvolutionaryEscalationEffect(this);
    }
}

