/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.EwokToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EwokAmbushCreateTokenEffect
extends OneShotEffect {
    EwokAmbushCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create two 1/1 green Ewok creature tokens. Those tokens gain haste until end of turn";
    }

    private EwokAmbushCreateTokenEffect(EwokAmbushCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public EwokAmbushCreateTokenEffect copy() {
        return new EwokAmbushCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new EwokToken(), 2);
            effect.apply(game, source);
            for (UUID tokenId : effect.getLastAddedTokenIds()) {
                Permanent token = game.getPermanent(tokenId);
                if (token == null) continue;
                GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenId));
                game.addEffect((ContinuousEffect)continuousEffect, source);
            }
            return true;
        }
        return false;
    }
}

