/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ExclusionRitualReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    ExclusionRitualReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't cast spells with the same name as the exiled card";
    }

    private ExclusionRitualReplacementEffect(ExclusionRitualReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card imprintedCard;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
        if (spellAbility == null) {
            return false;
        }
        Card card = spellAbility.getCharacteristics(game);
        if (card == null) {
            return false;
        }
        if (sourcePermanent != null && !sourcePermanent.getImprinted().isEmpty() && (imprintedCard = game.getCard((UUID)sourcePermanent.getImprinted().get(0))) != null) {
            return CardUtil.haveSameNames((MageObject)spellAbility.getCharacteristics(game), (MageObject)imprintedCard);
        }
        return false;
    }

    public ExclusionRitualReplacementEffect copy() {
        return new ExclusionRitualReplacementEffect(this);
    }
}

