/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class ExplosionOfRichesEffect
extends OneShotEffect {
    ExplosionOfRichesEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then each other player may draw a card. Whenever a card is drawn this way, {this} deals 5 damage to target opponent chosen at random from among your opponents";
    }

    private ExplosionOfRichesEffect(ExplosionOfRichesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExplosionOfRichesEffect copy() {
        return new ExplosionOfRichesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int cardsDrawn = 0;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !playerId.equals(source.getControllerId()) && !player.chooseUse(this.outcome, "Draw a card?", source, game)) continue;
            cardsDrawn += player.drawCards(1, source, game);
        }
        for (int i = 0; i < cardsDrawn; ++i) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(5), false, "{this} deals damage to target opponent chosen at random");
            TargetOpponent target = new TargetOpponent();
            target.setRandom(true);
            ability.addTarget((Target)target);
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        return true;
    }
}

