/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.abilities.keyword.DisguiseAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ExposeTheCulpritEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("face-up creatures you control with disguise");

    ExposeTheCulpritEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile any number of face-up creatures you control with disguise in a face-down pile, shuffle that pile, then cloak them.";
    }

    private ExposeTheCulpritEffect(ExposeTheCulpritEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExposeTheCulpritEffect copy() {
        return new ExposeTheCulpritEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List cardsToCloak;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent creatures = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        if (controller.choose(Outcome.Neutral, (Target)creatures, source, game) && controller.moveCards(new HashSet(cardsToCloak = creatures.getTargets().stream().map(x -> {
            Card card = game.getCard(x);
            if (card != null) {
                card.setFaceDown(true, game);
            }
            return card;
        }).filter(Objects::nonNull).collect(Collectors.toList())), Zone.EXILED, source, game)) {
            Collections.shuffle(cardsToCloak);
            game.informPlayers(controller.getLogName() + " shuffles the face-down pile");
            game.processAction();
            ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)controller, new LinkedHashSet(cardsToCloak), (boolean)true);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)FaceDownPredicate.instance));
        filter.add((Predicate)new AbilityPredicate(DisguiseAbility.class));
    }
}

