/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ExpressiveIterationEffect
extends OneShotEffect {
    ExpressiveIterationEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top three cards of your library. Put one of them into your hand, put one of them on the bottom of your library, and exile one of them. You may play the exiled card this turn";
    }

    private ExpressiveIterationEffect(ExpressiveIterationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExpressiveIterationEffect copy() {
        return new ExpressiveIterationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (cards.size() < 1) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(cards.size() == 3 ? 1 : 0, 1, StaticFilters.FILTER_CARD);
        target.withChooseHint("To put into your hand");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.HAND, source, game);
            cards.remove(card);
        }
        if (cards.isEmpty()) {
            return true;
        }
        target = new TargetCardInLibrary(cards.size() == 2 ? 1 : 0, 1, StaticFilters.FILTER_CARD);
        target.withChooseHint("To put on the bottom of your library");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.putCardsOnBottomOfLibrary(card, game, source);
            cards.remove(card);
        }
        if (cards.isEmpty()) {
            return true;
        }
        target = new TargetCardInLibrary();
        target.withChooseHint("To exile (you may play it this turn)");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        player.moveCardsToExile(card, source, game, true, source.getSourceId(), sourceObject.getIdName());
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        return true;
    }
}

