/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ExtinguishTheLightEffect
extends OneShotEffect {
    ExtinguishTheLightEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature or planeswalker. If its mana value was 3 or less, you gain 3 life.";
    }

    private ExtinguishTheLightEffect(ExtinguishTheLightEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtinguishTheLightEffect copy() {
        return new ExtinguishTheLightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int manaValue = permanent.getManaValue();
        permanent.destroy(source, game);
        if (manaValue <= 3 && (controller = game.getPlayer(source.getControllerId())) != null) {
            controller.gainLife(3, game, source);
        }
        return true;
    }
}

