/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ExtractFromDarknessEffect
extends OneShotEffect {
    ExtractFromDarknessEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Then you put a creature card from a graveyard onto the battlefield under your control";
    }

    private ExtractFromDarknessEffect(ExtractFromDarknessEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtractFromDarknessEffect copy() {
        return new ExtractFromDarknessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            target.withNotTarget(true);
            if (target.canChoose(source.getControllerId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                return controller.moveCards(game.getCard(target.getFirstTarget()), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

