/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.PhyrexianBeastToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class EzurisPredationEffect
extends OneShotEffect {
    EzurisPredationEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "For each creature your opponents control, create a 4/4 green Phyrexian Beast creature token. Each of those tokens fights a different one of those creatures";
    }

    private EzurisPredationEffect(EzurisPredationEffect effect) {
        super((OneShotEffect)effect);
    }

    public EzurisPredationEffect copy() {
        return new EzurisPredationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterCreaturePermanent filterCreature = new FilterCreaturePermanent();
            filterCreature.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
            List creaturesOfOpponents = game.getBattlefield().getActivePermanents((FilterPermanent)filterCreature, source.getControllerId(), source, game);
            HashSet<MageObjectReference> morSet = new HashSet<MageObjectReference>();
            if (!creaturesOfOpponents.isEmpty()) {
                CreateTokenEffect effect = new CreateTokenEffect((Token)new PhyrexianBeastToken(), creaturesOfOpponents.size());
                effect.apply(game, source);
                for (UUID tokenId : effect.getLastAddedTokenIds()) {
                    Permanent token = game.getPermanent(tokenId);
                    if (token == null) continue;
                    if (creaturesOfOpponents.isEmpty()) break;
                    Permanent opponentCreature = (Permanent)creaturesOfOpponents.iterator().next();
                    creaturesOfOpponents.remove(opponentCreature);
                    token.fight(opponentCreature, source, game, false);
                    morSet.add(new MageObjectReference((MageObject)token, game));
                    morSet.add(new MageObjectReference((MageObject)opponentCreature, game));
                    game.informPlayers(token.getLogName() + " fights " + opponentCreature.getLogName());
                }
                String data = UUID.randomUUID().toString();
                game.getState().setValue("batchFight_" + data, morSet);
                game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.BATCH_FIGHT, (UUID)this.getId(), (Ability)source, (UUID)source.getControllerId(), (String)data, (int)0));
            }
            return true;
        }
        return false;
    }
}

