/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.ControllerGainedLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class EzzarootChannelerEffect
extends CostModificationEffectImpl {
    EzzarootChannelerEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "creature spells you cast cost {X} less to cast, where X is the amount of life you gained this turn";
    }

    private EzzarootChannelerEffect(EzzarootChannelerEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, ControllerGainedLifeCount.instance.calculate(game, source, (Effect)this)));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && ((SpellAbility)abilityToModify).getCharacteristics(game).isCreature(game) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public EzzarootChannelerEffect copy() {
        return new EzzarootChannelerEffect(this);
    }
}

