/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class InvestigatedWatcher
extends Watcher {
    private final Map<UUID, Integer> timesInvestigated = new HashMap<UUID, Integer>();

    public InvestigatedWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.INVESTIGATED) {
            this.timesInvestigated.put(event.getPlayerId(), this.getTimesInvestigated(event.getPlayerId()) + 1);
        }
    }

    public void reset() {
        super.reset();
        this.timesInvestigated.clear();
    }

    public int getTimesInvestigated(UUID playerId) {
        return this.timesInvestigated.getOrDefault(playerId, 0);
    }
}

