/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ReturnSourceToBattlefieldEffect
extends OneShotEffect {
    ReturnSourceToBattlefieldEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "That player puts this card from its owner's graveyard onto the battlefield under their control";
    }

    private ReturnSourceToBattlefieldEffect(ReturnSourceToBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnSourceToBattlefieldEffect copy() {
        return new ReturnSourceToBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        return player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
    }
}

