/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ReturnToHandAllNamedPermanentsEffect
extends OneShotEffect {
    ReturnToHandAllNamedPermanentsEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target nonland permanent and all other permanents with the same name as that permanent to their owners' hands";
    }

    private ReturnToHandAllNamedPermanentsEffect(ReturnToHandAllNamedPermanentsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnToHandAllNamedPermanentsEffect copy() {
        return new ReturnToHandAllNamedPermanentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller != null && permanent != null) {
            FilterPermanent filter = new FilterPermanent();
            if (CardUtil.haveEmptyName((MageObject)permanent)) {
                filter.add((Predicate)new PermanentIdPredicate(permanent.getId()));
            } else {
                filter.add((Predicate)new NamePredicate(permanent.getName()));
            }
            CardsImpl cardsToHand = new CardsImpl();
            for (Permanent perm : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
                cardsToHand.add((Card)perm);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            return true;
        }
        return true;
    }
}

