/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class VenomLethalProtectorEffect
extends OneShotEffect {
    VenomLethalProtectorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature. If you do, draw X cards, then you may put a permanent card with mana value X or less from your hand onto the battlefield, where X is the sacrificed creature's mana value";
    }

    private VenomLethalProtectorEffect(VenomLethalProtectorEffect effect) {
        super((OneShotEffect)effect);
    }

    public VenomLethalProtectorEffect copy() {
        return new VenomLethalProtectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.Sacrifice, "Sacrifice another creature?", source, game) && cost.pay(source, game, source, source.getControllerId(), true))) {
            return false;
        }
        int amount = cost.getPermanents().stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        player.drawCards(amount, source, game);
        game.processAction();
        FilterPermanentCard filter = new FilterPermanentCard("permanent card with mana value " + amount + " or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, amount + 1));
        new PutCardFromHandOntoBattlefieldEffect((FilterCard)filter).apply(game, source);
        return true;
    }
}

