/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FabledPassageUntapLandEffect
extends OneShotEffect {
    FabledPassageUntapLandEffect() {
        super(Outcome.Untap);
        this.staticText = "Then if you control four or more lands, untap that land.";
    }

    public boolean apply(Game game, Ability source) {
        Card targetLandCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (targetLandCard == null) {
            return false;
        }
        if (game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), game) < 4) {
            return true;
        }
        Permanent land = game.getPermanent(targetLandCard.getId());
        if (land == null) {
            return false;
        }
        return land.untap(game);
    }

    private FabledPassageUntapLandEffect(FabledPassageUntapLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public FabledPassageUntapLandEffect copy() {
        return new FabledPassageUntapLandEffect(this);
    }
}

