/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FacesOfThePastEffect
extends OneShotEffect {
    FacesOfThePastEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap all untapped creatures that share a creature type with it or untap all tapped creatures that share a creature type with it";
    }

    private FacesOfThePastEffect(FacesOfThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public FacesOfThePastEffect copy() {
        return new FacesOfThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent targetPermanent = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        if (targetPermanent != null && (controller = game.getPlayer(targetPermanent.getControllerId())) != null) {
            if (controller.chooseUse(this.outcome, "Tap all untapped creatures that share a creature type with " + targetPermanent.getLogName() + "? (Otherwise, untaps all tapped)", source, game)) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                    if (permanent.isTapped() || !targetPermanent.shareCreatureTypes(game, (MageObject)permanent)) continue;
                    permanent.tap(source, game);
                }
            } else {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                    if (!permanent.isTapped() || !targetPermanent.shareCreatureTypes(game, (MageObject)permanent)) continue;
                    permanent.untap(game);
                }
            }
            return true;
        }
        return false;
    }
}

