/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FaerieImpostorEffect
extends OneShotEffect {
    FaerieImpostorEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "sacrifice it unless you return another creature you control to its owner's hand";
    }

    private FaerieImpostorEffect(FaerieImpostorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL, true);
        if (target.canChoose(controller.getId(), source, game) && controller.chooseUse(this.outcome, "Return another creature you control to its owner's hand?", source, game)) {
            controller.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
            permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                controller.moveCards((Card)permanent, Zone.HAND, source, game);
                return true;
            }
        }
        return (permanent = source.getSourcePermanentIfItStillExists(game)) != null && permanent.sacrifice(source, game);
    }

    public FaerieImpostorEffect copy() {
        return new FaerieImpostorEffect(this);
    }
}

