/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FalkenrathAristocratEffect
extends OneShotEffect {
    FalkenrathAristocratEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If the sacrificed creature was a Human, put a +1/+1 counter on {this}";
    }

    private FalkenrathAristocratEffect(FalkenrathAristocratEffect effect) {
        super((OneShotEffect)effect);
    }

    public FalkenrathAristocratEffect copy() {
        return new FalkenrathAristocratEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            Permanent sacrificedCreature = (Permanent)((SacrificeTargetCost)cost).getPermanents().get(0);
            Permanent sourceCreature = game.getPermanent(source.getSourceId());
            if (!sacrificedCreature.hasSubtype(SubType.HUMAN, game) || sourceCreature == null) continue;
            sourceCreature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            break;
        }
        return true;
    }
}

