/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FallersFaithfulEffect
extends OneShotEffect {
    FallersFaithfulEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy up to one other target creature. If that creature wasn't dealt damage this turn, its controller draws two cards";
    }

    private FallersFaithfulEffect(FallersFaithfulEffect effect) {
        super((OneShotEffect)effect);
    }

    public FallersFaithfulEffect copy() {
        return new FallersFaithfulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        boolean flag = permanent.getDealtDamageByThisTurn().isEmpty();
        permanent.destroy(source, game);
        game.processAction();
        if (!flag) {
            Optional.ofNullable(permanent).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(2, source, game));
        }
        return true;
    }
}

