/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;

class FalseDawnManaAddEffect
extends ReplacementEffectImpl {
    FalseDawnManaAddEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "Until end of turn, spells and abilities you control that would add colored mana instead add that much white mana.";
    }

    private FalseDawnManaAddEffect(FalseDawnManaAddEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FalseDawnManaAddEffect copy() {
        return new FalseDawnManaAddEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Mana mana = ((ManaEvent)event).getMana();
        mana.setWhite(mana.countColored());
        mana.setBlue(0);
        mana.setBlack(0);
        mana.setRed(0);
        mana.setGreen(0);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getControllerId(event.getSourceId()).equals(source.getControllerId());
    }
}

