/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.f.FarrelsMantleEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;

class FarrelsMantleTriggeredAbility
extends TriggeredAbilityImpl {
    FarrelsMantleTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private FarrelsMantleTriggeredAbility(FarrelsMantleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FarrelsMantleTriggeredAbility copy() {
        return new FarrelsMantleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNBLOCKED_ATTACKER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent aura = this.getSourcePermanentOrLKI(game);
        if (aura == null || !event.getTargetId().equals(aura.getAttachedTo()) || game.getPermanent(aura.getAttachedTo()) == null) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference(event.getTargetId(), game);
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add(Predicates.not((Predicate)new MageObjectReferencePredicate(mor)));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.setTargetController(game.getControllerId(event.getTargetId()));
        this.getTargets().clear();
        this.addTarget((Target)target);
        this.getEffects().clear();
        this.addEffect((Effect)new FarrelsMantleEffect(mor));
        return true;
    }

    public String getRule() {
        return "Whenever enchanted creature attacks and isn't blocked, its controller may have it deal damage equal to its power plus 2 to another target creature. If that player does, the attacking creature assigns no combat damage this turn.";
    }
}

