/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class FatedFirepowerEffect
extends ReplacementEffectImpl {
    private static final DynamicValue xValue = new CountersSourceCount(CounterType.FIRE);

    FatedFirepowerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "if a source you control would deal damage to an opponent or a permanent an opponent controls, it deals that much damage plus an amount of damage equal to the number of fire counters on this enchantment instead.";
    }

    private FatedFirepowerEffect(FatedFirepowerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)xValue.calculate(game, source, (Effect)this)));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && controller.hasOpponent(FatedFirepowerEffect.getControllerOrSelf(event.getTargetId(), game), game) && source.isControlledBy(game.getControllerId(event.getSourceId())) && event.getAmount() > 0;
    }

    private static UUID getControllerOrSelf(UUID id, Game game) {
        UUID outId = game.getControllerId(id);
        return outId == null ? id : outId;
    }

    public FatedFirepowerEffect copy() {
        return new FatedFirepowerEffect(this);
    }
}

