/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class FatespinnerSkipEffect
extends ReplacementEffectImpl {
    private final String phase;

    public FatespinnerSkipEffect(String phase) {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.phase = phase;
    }

    private FatespinnerSkipEffect(FatespinnerSkipEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.phase = effect.phase;
    }

    public FatespinnerSkipEffect copy() {
        return new FatespinnerSkipEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        GameEvent.EventType type = event.getType();
        return this.phase.equals("Draw step") && type == GameEvent.EventType.DRAW_STEP || this.phase.equals("Main phase") && (type == GameEvent.EventType.PRECOMBAT_MAIN_PHASE || type == GameEvent.EventType.POSTCOMBAT_MAIN_PHASE) || this.phase.equals("Combat phase") && type == GameEvent.EventType.COMBAT_PHASE;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        GameEvent.EventType type = event.getType();
        return type == GameEvent.EventType.DRAW_STEP || type == GameEvent.EventType.PRECOMBAT_MAIN_PHASE || type == GameEvent.EventType.POSTCOMBAT_MAIN_PHASE || type == GameEvent.EventType.COMBAT_PHASE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }
}

