/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FathomFeederEffect
extends OneShotEffect {
    public FathomFeederEffect() {
        super(Outcome.Exile);
        this.staticText = "Each opponent exiles the top card of their library";
    }

    private FathomFeederEffect(FathomFeederEffect effect) {
        super((OneShotEffect)effect);
    }

    public FathomFeederEffect copy() {
        return new FathomFeederEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Card card;
            Player player = game.getPlayer(opponentId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            player.moveCards(card, Zone.EXILED, source, game);
        }
        return true;
    }
}

