/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObjectReference;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.f.FblthpTheLostWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;

class FblthpTheLostTriggeredAbility
extends EntersBattlefieldTriggeredAbility {
    FblthpTheLostTriggeredAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1));
        this.addWatcher(new FblthpTheLostWatcher());
    }

    private FblthpTheLostTriggeredAbility(FblthpTheLostTriggeredAbility ability) {
        super((EntersBattlefieldTriggeredAbility)ability);
    }

    public FblthpTheLostTriggeredAbility copy() {
        return new FblthpTheLostTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        EntersTheBattlefieldEvent entersEvent = (EntersTheBattlefieldEvent)event;
        if (entersEvent.getFromZone() == Zone.LIBRARY) {
            this.getEffects().clear();
            this.addEffect((Effect)new DrawCardSourceControllerEffect(2));
            return true;
        }
        FblthpTheLostWatcher watcher = (FblthpTheLostWatcher)game.getState().getWatcher(FblthpTheLostWatcher.class);
        int zcc = entersEvent.getTarget().getZoneChangeCounter(game) - 1;
        MageObjectReference mor = new MageObjectReference(entersEvent.getTargetId(), zcc, game);
        if (watcher != null && watcher.spellWasCastFromLibrary(mor)) {
            this.getEffects().clear();
            this.addEffect((Effect)new DrawCardSourceControllerEffect(2));
            return true;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
        return true;
    }

    public String getRule() {
        return "When {this} enters, draw a card. If it entered from your library or was cast from your library, draw two cards instead.";
    }
}

