/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class FearlessSwashbucklerWatcher
extends Watcher {
    private boolean pirateAttacked = false;
    private boolean vehicleAttacked = false;

    FearlessSwashbucklerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ATTACKER_DECLARED: {
                break;
            }
            case COMBAT_PHASE_POST: {
                this.pirateAttacked = false;
                this.vehicleAttacked = false;
            }
            default: {
                return;
            }
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null) {
            return;
        }
        if (permanent.hasSubtype(SubType.PIRATE, game)) {
            this.pirateAttacked = true;
        }
        if (permanent.hasSubtype(SubType.VEHICLE, game)) {
            this.vehicleAttacked = true;
        }
    }

    public void reset() {
        super.reset();
        this.pirateAttacked = false;
        this.vehicleAttacked = false;
    }

    boolean check() {
        return this.pirateAttacked && this.vehicleAttacked;
    }
}

