/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FecundityEffect
extends OneShotEffect {
    FecundityEffect() {
        super(Outcome.DrawCard);
        this.staticText = "that creature's controller may draw a card";
    }

    private FecundityEffect(FecundityEffect effect) {
        super((OneShotEffect)effect);
    }

    public FecundityEffect copy() {
        return new FecundityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        if (permanent != null && (controller = game.getPlayer(permanent.getControllerId())) != null) {
            if (controller.chooseUse(this.outcome, "Draw a card?", source, game)) {
                controller.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

