/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class FeedTheInfectionEffect
extends OneShotEffect {
    FeedTheInfectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "<br>" + AbilityWord.CORRUPTED.formatWord() + "Each opponent who has three or more poison counters loses 3 life";
    }

    private FeedTheInfectionEffect(FeedTheInfectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeedTheInfectionEffect copy() {
        return new FeedTheInfectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getCountersCount(CounterType.POISON) < 3) continue;
            player.loseLife(3, game, source, false);
        }
        return true;
    }
}

