/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FeedTheSwarmEffect
extends OneShotEffect {
    FeedTheSwarmEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target creature or enchantment an opponent controls. You lose life equal to that permanent's mana value";
    }

    private FeedTheSwarmEffect(FeedTheSwarmEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeedTheSwarmEffect copy() {
        return new FeedTheSwarmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        player.loseLife(permanent.getManaValue(), game, source, false);
        permanent.destroy(source, game, false);
        return true;
    }
}

