/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.permanent.Permanent;

class FelixFiveBootsEffect
extends ReplacementEffectImpl {
    FelixFiveBootsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature you control dealing combat damage to a player causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private FelixFiveBootsEffect(FelixFiveBootsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FelixFiveBootsEffect copy() {
        return new FelixFiveBootsEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent triggeringPermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (triggeringPermanent == null || !triggeringPermanent.isControlledBy(source.getControllerId())) {
            return false;
        }
        GameEvent sourceEvent = ((NumberOfTriggersEvent)event).getSourceEvent();
        if (sourceEvent instanceof DamagedEvent) {
            return FelixFiveBootsEffect.checkDamagedEvent((DamagedEvent)sourceEvent, source.getControllerId(), game);
        }
        if (sourceEvent instanceof BatchEvent) {
            TriggeredAbility sourceTrigger = ((NumberOfTriggersEvent)event).getSourceTrigger();
            for (Object o : sourceTrigger instanceof BatchTriggeredAbility ? ((BatchTriggeredAbility)sourceTrigger).getFilteredEvents((BatchEvent)sourceEvent, game) : ((BatchEvent)sourceEvent).getEvents()) {
                if (!(o instanceof DamagedEvent) || !FelixFiveBootsEffect.checkDamagedEvent((DamagedEvent)o, source.getControllerId(), game)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkDamagedEvent(DamagedEvent event, UUID controllerId, Game game) {
        if (!event.isCombatDamage() || game.getPlayer(event.getTargetId()) == null) {
            return false;
        }
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return sourcePermanent != null && sourcePermanent.isCreature(game) && sourcePermanent.isControlledBy(controllerId);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

