/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class FellGravshipEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature or Spacecraft card");

    FellGravshipEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return a creature or Spacecraft card from your graveyard to your hand";
    }

    private FellGravshipEffect(FellGravshipEffect effect) {
        super((OneShotEffect)effect);
    }

    public FellGravshipEffect copy() {
        return new FellGravshipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count(filter, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.SPACECRAFT.getPredicate()));
    }
}

