/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FellTheMightyEffect
extends OneShotEffect {
    FellTheMightyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures with power greater than target creature's power";
    }

    private FellTheMightyEffect(FellTheMightyEffect effect) {
        super((OneShotEffect)effect);
    }

    public FellTheMightyEffect copy() {
        return new FellTheMightyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && targetCreature != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), source, game)) {
                if (permanent.getPower().getValue() <= targetCreature.getPower().getValue()) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

