/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class FerventMasteryEffect
extends OneShotEffect {
    FerventMasteryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to three cards, put them into your hand, shuffle, then discard three cards at random.";
    }

    private FerventMasteryEffect(FerventMasteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public FerventMasteryEffect copy() {
        return new FerventMasteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(3, StaticFilters.FILTER_CARD);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        player.shuffleLibrary(source, game);
        player.discard(3, true, false, source, game);
        return true;
    }
}

