/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class FettergeistUnlessPaysEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public FettergeistUnlessPaysEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice {this} unless you pay {1} for each other creature you control.";
    }

    private FettergeistUnlessPaysEffect(FettergeistUnlessPaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            ManaCost cost;
            PermanentsOnBattlefieldCount amount = new PermanentsOnBattlefieldCount((FilterPermanent)filter, Integer.valueOf(1));
            int count = amount.calculate(game, source, (Effect)this);
            if (player.chooseUse(Outcome.Benefit, "Pay {" + count + "}?  Or " + permanent.getName() + " will be sacrificed.", source, game) && (cost = ManaUtil.createManaCost((int)count, (boolean)false)).pay(source, game, source, source.getControllerId(), false)) {
                return true;
            }
            permanent.sacrifice(source, game);
            return true;
        }
        return false;
    }

    public FettergeistUnlessPaysEffect copy() {
        return new FettergeistUnlessPaysEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

