/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.GiantWarriorToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class FeudkillersVerdictEffect
extends OneShotEffect {
    FeudkillersVerdictEffect() {
        super(Outcome.Benefit);
        this.staticText = "You gain 10 life. Then if you have more life than an opponent, create a 5/5 white Giant Warrior creature token";
    }

    private FeudkillersVerdictEffect(FeudkillersVerdictEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeudkillersVerdictEffect copy() {
        return new FeudkillersVerdictEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(10, game, source);
            boolean moreLife = false;
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null || controller.getLife() <= opponent.getLife()) continue;
                moreLife = true;
                break;
            }
            if (moreLife) {
                return new CreateTokenEffect((Token)new GiantWarriorToken(), 1).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

