/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FeveredSuspicionEffect
extends OneShotEffect {
    FeveredSuspicionEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles cards from the top of their library until they exile a nonland card. You may cast any number of spells from among those nonland cards without paying their mana costs";
    }

    private FeveredSuspicionEffect(FeveredSuspicionEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeveredSuspicionEffect copy() {
        return new FeveredSuspicionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        CardsImpl nonlands = new CardsImpl();
        block0: for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            for (Card card : opponent.getLibrary().getCards(game)) {
                cards.add(card);
                if (card.isLand(game)) continue;
                nonlands.add(card);
                continue block0;
            }
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        nonlands.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)nonlands, (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }
}

