/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.effects.common.UntapAllLandsControllerEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FieryGambitEffect
extends OneShotEffect {
    FieryGambitEffect() {
        super(Outcome.Benefit);
        this.staticText = "Flip a coin until you lose a flip or choose to stop flipping. If you lose a flip, {this} has no effect. If you win one or more flips, {this} deals 3 damage to target creature. If you win two or more flips, {this} deals 6 damage to each opponent. If you win three or more flips, draw nine cards and untap all lands you control";
    }

    private FieryGambitEffect(FieryGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public FieryGambitEffect copy() {
        return new FieryGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            int flipsWon = 0;
            boolean controllerStopped = false;
            while (controller.flipCoin(source, game, true)) {
                if (!controller.chooseUse(this.outcome, "You won " + ++flipsWon + (flipsWon == 1 ? " flip." : " flips.") + " Flip another coin?", source, game)) {
                    controllerStopped = true;
                    break;
                }
                if (!controller.isComputer() || flipsWon < 3) continue;
                controllerStopped = true;
                break;
            }
            if (controllerStopped) {
                Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (creature != null) {
                    creature.damage(3, source.getSourceId(), source, game, false, true);
                }
                if (flipsWon > 1) {
                    new DamagePlayersEffect(6, TargetController.OPPONENT).apply(game, source);
                }
                if (flipsWon > 2) {
                    controller.drawCards(9, source, game);
                    new UntapAllLandsControllerEffect().apply(game, source);
                }
            } else {
                game.informPlayers(sourceObject.getIdName() + " had no effect");
            }
            return true;
        }
        return false;
    }
}

